from optparse import OptionParser
import os, sys, time

#-------------------------------------
#log file definition
#-------------------------------------
def debugfilelog(message):
	print >>sys.stderr, "%s :: %s" % (time.strftime("%d/%m/%Y %H:%M:%S"), message)

#-------------------------------------
#use config file
#-------------------------------------
class GlobalConfig:
    days = None
    fileLoc = None
    accessName = None
    errorName = None

    def __init__(self, configFile):
		import ConfigParser
		config = ConfigParser.ConfigParser()
		config.optionxform = str
		config.read(configFile)

                GlobalConfig.days = config.get("config", "days")
                GlobalConfig.fileLoc = config.get("config", "fileLoc")
                GlobalConfig.accessName = config.get("config", "accessName")
                GlobalConfig.errorName = config.get("config", "errorName")

#-------------------------------------
#delete files definition
#-------------------------------------
def deleteFiles(days, fileLoc, accessName, errorName):

    current_time = time.time()

    print "About to delete files.."
    debugfilelog("About to delete files...")

    current_time = time.time()

    fileDir = os.listdir(fileLoc)
    numFiles = len(fileDir)
    if numFiles == 0 :
            print "No files in the directory " + fileLoc + ". Nothing to delete..."
            debugfilelog("No files in the directory " + fileLoc + ". Nothing to delete...")
            
    #Delete Files For Loop
    for files in os.listdir(fileLoc):

        fileToDelete = os.path.join(fileLoc, files)
        creation_time = os.path.getctime(fileToDelete)
        numToDivide = current_time - creation_time
        daysInPast = int(numToDivide // 86400)

        #stuff below used for debug only
        #print fileToDelete
        #print accessName
        #print errorName
        #print days
        #print daysInPast
        
        if int(daysInPast) >= int(days) :
                
            if not files.find(accessName.translate(None, '"')) == -1 or not files.find(errorName.translate(None, '"')) == -1 :
                print "File " + files + " is within " + days + " day(s) old and matches parameters to delete. Removing File..."
                debugfilelog("File " + files + " is within " + days + " day(s) old and matches parameters to delete. Removing File...")
                os.unlink(fileToDelete)
                print('{} removed'.format(fileToDelete))
                debugfilelog("Removed file: " + fileToDelete + ". Moving to next file...")
            else :
                print files + " is within " + days + " day(s) old but does not contain " + accessName + " or " + errorName + " in the file name. Skipping..."
                debugfilelog("File " + files + " is within " + days + " day(s) old but does not contain " + accessName + " or " + errorName + " in the file name. Skipping...")
                continue
        else:
            print "File " + files + " is not older than " + days + " days old. Skipping..."
            debugfilelog("File " + files + " is not older than " + days + " days old. Skipping...")


    print "Done trying to delete files."
    debugfilelog("Done trying to delete files.")
        
            
#-------------------------------------
#main
#-------------------------------------
this_script_base_name = os.path.splitext(os.path.basename(sys.argv[0]))[0]

#delete old log file for script
logfile = this_script_base_name + ".log"
if os.path.isfile(logfile) :
        print "log file exists. Deleting log file..."
        os.unlink(logfile)
        print "Done deleting old log file."

sys.stderr = file(this_script_base_name + ".log", 'a', 0)


#deal with options
parser = OptionParser(description="Imports patron files into Atriuum")
parser.add_option("-c", "--config",
				  dest="config",
				  help="Configuration file for this tool. <NAME> is the name of the config file.",
				  metavar="<NAME>")

(options, args) = parser.parse_args()

#if no options, set config file
if options.config == None:
	configName = this_script_base_name + ".ini"
else:
	configName = options.config


#handle if no config file
if os.path.exists(configName) == False:
    print 
    print "Config file", configName, "does not exist."
    debugfilelog("No config file!")
    parser.print_help()
    print
    sys.exit()
else:
    print 
    print "Config file", configName, "found. Continuing..."
    debugfilelog("Found config file. Continuing...")
    print
    
GlobalConfig(configName)

#-------------------------------------
#check if all important vars have values
#-------------------------------------

#set error check variable
haserror="NO"
    
#ensure that days variable is set
if GlobalConfig.days == "" :
    print "No number of days set! Set days variable to the max number of days you wish to keep files."
    debugfilelog("No number of days set! Set days variable to the max number of days you wish to keep files.")
    haserror = "YES"
else :
    print "Number of days set for " + GlobalConfig.days + ". Continuing..."
    debugfilelog("Number of days set for " + GlobalConfig.days + ". Continuing...")
    
    #ensure FileLoc is set
if GlobalConfig.fileLoc == "" :
    print "No file location set! Set fileLoc variable to the location of files you wish to delete."
    debugfilelog("No file location set! Set fileLoc variable to the location of files you wish to delete.")
    haserror = "YES"
else :
    print "File Location set for " + GlobalConfig.fileLoc + ". Continuing..."
    debugfilelog("File Location set for " + GlobalConfig.fileLoc + ". Continuing...")

#ensure accessName is set
if GlobalConfig.accessName == "" :
    print "No access file filter set! Set accessName variable to the filter string for access log files."
    debugfilelog("No access file filter set! Set accessName variable to the filter string for access log files.")
    haserror = "YES"
else :
    print "Access filter string set for " + GlobalConfig.accessName + ". Continuing..."
    debugfilelog("Access filter string set for " + GlobalConfig.accessName + ". Continuing...")

#ensure errorName is set
if GlobalConfig.errorName == "" :
    print "No error file filter set! Set accessName variable to the filter string for access log files."
    debugfilelog("No errorName file filter set! Set accessName variable to the filter string for access log files.")
    haserror = "YES"
else :
    print "Error filter string set for " + GlobalConfig.errorName + ". Continuing..."
    debugfilelog("Error filter string set for " + GlobalConfig.errorName + ". Continuing...")

#check if any config file errors exist
if "YES" in haserror :
    print "Config file has errors. Correct and then re-run the script. Exiting script."
    debugfilelog("Config file has errors. Correct and then re-run the script. Exiting script.")
    sys.exit()

print 
print "Using the following configuration:"
print "-----------------------------------"
print "Days: %s" % GlobalConfig.days
print "File Location: %s" % GlobalConfig.fileLoc
print "Access File Name String: %s" % GlobalConfig.accessName
print "Error File Name String: %s" % GlobalConfig.errorName
print "-----------------------------------"
print

deleteFiles(GlobalConfig.days, GlobalConfig.fileLoc, GlobalConfig.accessName, GlobalConfig.errorName)
